<!--------------------------------------------------------------------------------------------------->
<!--- File Name: send_email.cfm                                                                   --->
<!--- OpenSource Software Name:  Web Email Sender                                                 --->
<!---                                                                                             --->
<!--- Developer: Jay Hatcher                                                                      --->
<!--- Project Manager: Prof Craighton Hippenhammer, Olivet Nazarene University                    --->
<!--- If you use this code, please let the project manager know [chhammer@olivet.edu]. Thank you. --->
<!--------------------------------------------------------------------------------------------------->

<HTML>
<HEAD>
<TITLE>Web Email Sender</TITLE>
</HEAD>

<BODY>

<!--- URL.id is the id number for a particular name and email address stored in your database table called "EmailTable" --->

<cfif isdefined("URL.id")>                                
<CFQUERY name="EmailQuery" datasource="DatasourceName">   <!--- Change data source to your own DataSourceName --->
	SELECT ID, name FROM EmailTable WHERE ID=#URL.id#
</CFQUERY>
</cfif>

<!--- This <cfif> tag runs if we are finished sending the email and it will display a confirmation or error message --->

<cfif isdefined("URL.err")>

	<!--- We have returned from send_email_do.cfm --->

	<cfif #URL.err# is 0>
		<cfoutput>
		Your message was successfully sent.<BR>
		</cfoutput>
	<cfelse>
		<cfoutput>
		An error occurred when sending your message.<BR>
		</cfoutput>
	</cfif>

	<cfoutput>

	<!--- Allow your Web page user to leave since we are finished sending the message --->

	Return to the <a href="index.htm">Library's Home Page</a>.
	</cfoutput>

<!--- This section runs if we haven't sent the email yet and need to fill out the email form. --->
<cfelse>

	<cfoutput>
	<h2>Send Email to #EmailQuery.name#</h2>
	</cfoutput>

	<!--- Create the email form --->

	<cfform action="send_email_do.cfm" method="post">

		<!--- Pass the id number along to send_email_do.cfm --->
		<input type="Hidden" NAME="id" value=#URL.id#>

		<!--- Collect information from the user --->
		From: (email address) 
		<input type="text" name="from" size="38"><BR><BR>

		Subject: 
		<input type="text" name="subject" size="50"><BR><BR>

		Message:<BR>
		<textarea name="message" rows="10" cols="80"></textarea><BR><BR>
		
		<INPUT type="submit" name="send" value="Send">
		<INPUT type="reset" name="clear" value="Clear">

		<!--- Send the email information to send_email_do.cfm for processing --->

	</cfform>
</cfif>

</BODY>
</HTML>